#!/usr/bin/env python3
# Copyright (C) 2024 Nathaniel Klumb
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

from boxes import *


class ClosedEdgeBox(Boxes):
    """Fully closed edge-joint box"""

    ui_group = "Box"

    description = """A riff on the basic ClosedBox that
can be used with acrylic where tab-in-groove is acceptable
but open finger joints are not."""

    def __init__(self) -> None:
        Boxes.__init__(self)
        self.addSettingsArgs(edges.FingerJointSettings)
        self.buildArgParser("x", "y", "h", "outside")

    def render(self):
        x, y, h = self.x, self.y, self.h
        t = self.thickness

        if self.outside:
            x = self.adjustSize(x)
            y = self.adjustSize(y)
            h = self.adjustSize(h)

        self.rectangularWall(x, h, "ffff", move="right", label="Side")
        self.rectangularWall(y, h, "fhfh", move="up", label="End")
        self.rectangularWall(y, h, "fhfh", label="End")
        self.rectangularWall(x, h, "ffff", move="left up", label="Side")
        
        self.rectangularWall(x, y, "hhhh", move="right", label="Cap")
        self.rectangularWall(x, y, "hhhh", label="Cap")
